/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.StringEntrySelectScreen;
import doggytalents.client.screen.framework.widget.FlatButton;
import doggytalents.common.entity.DogGroupsManager;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.HeelByGroupData;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraftforge.network.PacketDistributor;

public class HeelByGroupScreen
extends StringEntrySelectScreen {
    private final List<DogGroupsManager.DogGroup> dogGroupList = new ArrayList<DogGroupsManager.DogGroup>();
    private boolean heelAndSit = false;
    private final int HLC_HEEL_AND_SIT = 0xFF6F00;

    public HeelByGroupScreen() {
        super((Component)Component.m_237115_((String)"doggytalents.screen.heel_by_group"));
    }

    public static void open() {
        Minecraft mc = Minecraft.m_91087_();
        HeelByGroupScreen screen = new HeelByGroupScreen();
        mc.m_91152_((Screen)screen);
        screen.requestGroups();
    }

    @Override
    protected void addUtilitiesButton() {
        int mX = this.f_96543_ / 2;
        int mY = this.f_96544_ / 2;
        FlatButton help = new FlatButton(mX - 100 - 20 - 2, mY - 100, 20, 20, (Component)Component.m_237113_((String)"?"), b -> {}){

            public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.m_88315_(graphics, mouseX, mouseY, pTicks);
                if (!this.f_93622_) {
                    return;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(Component.m_237115_((String)"doggytalents.screen.heel_by_group.help_title").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                String str = I18n.m_118938_((String)"doggytalents.screen.heel_by_group.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, HeelByGroupScreen.this.f_96547_));
                graphics.m_280666_(HeelByGroupScreen.this.f_96547_, list, mouseX, mouseY);
            }
        };
        this.m_142416_((GuiEventListener)help);
    }

    @Override
    protected void drawNoEntryMsg(GuiGraphics graphics, int x, int y) {
        graphics.m_280488_(this.f_96547_, I18n.m_118938_((String)"doggytalents.screen.heel_by_group.no_group_found", (Object[])new Object[0]), x, y, 16058890);
    }

    @Override
    protected Component modifyEntryText(Component entryText, int entryId, boolean is_selected) {
        if (this.heelAndSit && is_selected) {
            entryText = entryText.m_6881_().m_130948_(Style.f_131099_.m_178520_(0xFF6F00));
        }
        return entryText;
    }

    @Override
    protected void drawEntry(GuiGraphics graphics, int entry_x, int entry_y, int entry_id, boolean is_selected) {
        super.drawEntry(graphics, entry_x + 12, entry_y, entry_id, is_selected);
        DogGroupsManager.DogGroup group = this.dogGroupList.get(entry_id);
        graphics.m_280509_(entry_x, entry_y - 1, entry_x + 9, entry_y - 1 + 9, group.color);
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340) {
            this.heelAndSit = true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340) {
            this.heelAndSit = false;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    @Override
    protected void onEntrySelected(int id) {
        this.requestHeelByGroup(this.dogGroupList.get(id), this.heelAndSit);
        Minecraft.m_91087_().m_91152_(null);
    }

    private void requestGroups() {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new HeelByGroupData.REQUEST_GROUP_LIST());
    }

    public void assignResponse(List<DogGroupsManager.DogGroup> groups) {
        this.dogGroupList.clear();
        for (DogGroupsManager.DogGroup group : groups) {
            this.dogGroupList.add(group);
        }
        this.updateEntries(this.dogGroupList.stream().map(x -> x.name).collect(Collectors.toList()));
    }

    private void requestHeelByGroup(DogGroupsManager.DogGroup group, boolean heelAndSit) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new HeelByGroupData.REQUEST_HEEL(group, heelAndSit));
    }

    public boolean m_7043_() {
        return false;
    }
}

